

/******************************************************************************************
 *                                                                                        *
 *  Ex1.     :  Read BCD ET-Matrix Key Decoder for Key PAD 4x4 and 4x3                    *
 *                  (Connect Key Pad 4x4 or 4x3 to KEY_IN1 or KEY_IN2)                    *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 * Target MCU     : ATMEL AT89C51RE2                                                      *
 *       	      : X-TAL : 18.432 MHz                                                    *
 *                                                                                        *
 * Keil Editor    : uVision3 V3.62C                                                       *
 * Compiler       : Keil C51 (V9.51)                                                      *
 *                                                                                        *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                               *
 * Last Update       : 13/April/2015                                                      *
 *                                                                                        *
 * I/P BCD Port      :  -- MCU-AT89C51RE2--              -- ET-Matrix Key Decoder --      *
 *                                                                                        *
 *                     P1.0(Input)          Connect                 BCD1                  * 
 *                     P1.1(Input)          Connect                 BCD2                  *
 *                     P1.2(Input)          Connect                 BCD4                  *
 *                     P1.3(Input)          Connect                 BCD8                  *
 *                     P1.4(Input)          Connect                 P#/R Ststus Key       *
 *                                                                                        * 
 * O/P Display Port  :                                                                    *
 *                                                                                        *
 *               LED : Connect Common Anode(LED Active Low)                               *
 *                     P0.0              Connect                   LED0(BCD1)             *
 *                     P0.1              Connect                   LED1(BCD2)             *  
 *                     P0.2              Connect                   LED2(BCD4)             *
 *                     P0.3              Connect                   LED3(BCD8)             *
 *                                                                                        *
 *                                                                             5V         *
 *                                                                             -+-        *
 *                                                              560      \\     |         *
 *                                                      P0.0 --/\/\/\---|<|-----+         *
 *                                                                      .       |         *
 *                                                              560     . \\    |         *
 *                                                      P0.3 --/\/\/\-----|<|---+         *
 *                                                                                        *
 *                                                                                        *
 *  RS232#1 UART0   : P3.1 = TX0          Connect              Rx PC                      *
 *                    P3.0 = RX0          Connect              Tx PC                      *                                                                        *
 *                    Baud Rate = 9600  at Clock 18.432 Mhz (6 Clock)                     *
 *                                                                                        *
 *                                                                                        *
 *  Operation  : When Touch Key will Show Key Code(Hex) on Heperterminal and LED P0[0..3] *  
 *                                                                                        *
 ******************************************************************************************/

#include <at89c51xd2.h>            /* AT89C51xD2 definitions                      */
#include <stdio.h>                 /* prototype declarations for I/O functions     */
                         

char Check_PR(void)     ;
char RD_KeyCode(void)   ;
 

//*************************** Main *************************

void main (void) 
    {                               
     unsigned int key ;                               


     CKCON0 = 0x01   ;  //div 6 clk mode  X2=1
     AUXR   = 0x10   ;  //Set XRAM = 1792 Byte
 
	
   //---------initial Uart0 ------------

    BRL     = 0x88  ;  // Baud Rate 9600
    PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   
    BDRCON  = 0x1E  ;  // Select Internal Baud-Rate,enable,0x1E=Fast BR. //0x1C=No fast BR.	 
    SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
    ES      = 0     ;  // Disable Serial Uart  Interrupt    
  
    TI=1            ;
    
    
    //---------------- Main -----------------
    
    printf("*************************************************************************\r\n");    
    printf("**          Ex1.TEST READ BCD KEY CODE ET-Matrix Key Decoder           **\r\n");        
    printf("*************************************************************************\r\n"); 
  
    while(1)
     {
       if(!Check_PR())                             //Step1: Check  pressed key (Check_PR()=0:press,1:release) 
        {
         key = RD_KeyCode()                     ;  //Step2: Read Key Code

         //---------- Step3:Program Respond press key for user ------------
       
          P0 = ~key                            ;   //Out Hex data BCD key Code to LED P0[0..3]
          printf("Key_Code BCD = 0x0%X",key)   ;   //Print Key Code Out RS232 baudrate 9600
          printf("\n\r")                       ;

          while(!Check_PR()){;}                ;   //Wait Release Key (=1 exit loop)
        }          
     }   //while
   }

//********************** Sub Program *************************

//---------------------- Check Touch /Release Key -------------------

char Check_PR(void)    
 {
   char pr   ;
        
   P1  = 0xFF                ;	 //Set P1 Input
   pr  = P1                  ;   //Read Status Key
   pr  = pr & 0x10           ;   //Mark bit P1.4 (Statust Press or Release)
	
   if(pr != 0x10)                //Check Statue Key
	   return (0)            ;	 //Touch Key Return 0 (P1.4=0)
	else
 	   return (1)            ;	 //Release Key Return 1	(P1.4=1)

 }


//---------- Read BCD Key Code -----------------

 char RD_KeyCode(void) 
  {
    unsigned char KeyCode                 ;
	
    P1           = 0xFF                   ;
    KeyCode      = P1                     ;   //Read Key Code
    KeyCode      = KeyCode & 0x0F         ;   //Mark bit P1.0-P1.3(Key Code 4 bit)
    return (KeyCode)                      ;

  }








 